﻿<%@ Page Title="Patient Related Diagnoses" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" 
    CodeBehind="PatientRelatedDiagnoses.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.PatientRelatedDiagnoses" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <asp:Panel runat="server" ID="PanelPatientInfo" GroupingText="&nbsp;Patient Information&nbsp;">
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforLabelPatientName" runat="server" AssociatedControlID="LabelPatientName" ToolTip="Patient Name" >Patient Name:&nbsp;&nbsp;</asp:Label>
        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" ToolTip="Patient Name"/>
        <br />
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelforLabelPatientSnum" runat="server" AssociatedControlID="LabelPatientSnum" ToolTip="Patient SSN" > SSN:&nbsp;&nbsp;</asp:Label>
        <asp:Label SkinID="DataLabel" ID="LabelPatientSnum" runat="server" ToolTip="Patient SSN" />
    </asp:Panel>

    <br />
    <br />

<asp:Panel runat="server" ID="pnlRelatedDiag" GroupingText="Related Diagnoses">
    <asp:GridView ID="GridViewRelatedDiagnostics" runat="server" SkinID = "Unsortable" ToolTip="To sort please click table headings."
        AutoGenerateColumns="False" AllowSorting="True" DataSourceID="ObjectDataSourceRelatedDiagnostics"
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
        <Columns>
            <asp:BoundField DataField="ID" HeaderText="ID" SortExpression="ID" 
                Visible="False" />
            <asp:BoundField DataField="ICDCode" HeaderText="ICD Code" 
                SortExpression="ICDCode" />
            <asp:BoundField DataField="ICDCodeSet" HeaderText="ICD Code Set" 
                SortExpression="ICDCodeSet" ItemStyle-Width="15" />
            <asp:BoundField DataField="ICDCodeName" HeaderText="Description" 
                SortExpression="ICDCodeName" />
            <asp:TemplateField HeaderText="Encounter Date" SortExpression="EncounterDate">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelEncounterDate" runat="server" 
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("EncounterDate", "{0:d}"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="SiteCode" HeaderText="Site Number" 
                SortExpression="SiteCode" />
            <asp:BoundField DataField="FacilityName" HeaderText="Facility Name" 
                SortExpression="FacilityName" />
        </Columns>
            
        <EmptyDataTemplate>
                    <div style="width:100%"><span>No Records Available.</span> </div>
                    </EmptyDataTemplate>
    </asp:GridView></asp:Panel>

    <asp:ObjectDataSource ID="ObjectDataSourceRelatedDiagnostics" runat="server" 
        OldValuesParameterFormatString="original_{0}" SelectMethod="GetRelatedDiagnosticsForPatient" 
        SortParameterName="SORT_COLUMN"
        TypeName="VIRP.EFR.BLL.RelatedDiagnosticsManager"
        DataObjectTypeName="VIRP.EFR.BO.RelatedDiagnosticsView">
        <SelectParameters>
            <asp:Parameter Name="CURRENT_USER" Type="String" />
            <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="PATIENT_ID" QueryStringField="patientId" Type="String" />
            <asp:Parameter Name="SORT_COLUMN" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>

    <br /><br /><br /><br />

    <asp:LinkButton ID="LinkButtonPatientInformation" runat="server" Text="Patient Information" ToolTip="Select to see patient information" style="padding:4px; border:1px solid white;" OnClick="LinkButtonPatientInformation_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonWorkflows" runat="server" Text="Workflows" ToolTip="Select to see workflows for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonWorkflows_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonLabTests" runat="server" Text="Lab Tests" ToolTip="Select to see lab tests for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonLabTests_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonImages" runat="server" Text="Images" ToolTip="Select to see images for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonImages_Click" />&nbsp;

</asp:Content>

